/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.collection.iteration;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.collection.iteration.Indexed;
import icyllis.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import icyllis.flexmark.util.collection.iteration.ReversibleIterator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class IndexedIterator<R, S, I extends ReversibleIterator<Integer>>
implements ReversibleIndexedIterator<R> {
    private final I iterator;
    private final Indexed<S> items;
    private int lastIndex;
    private int modificationCount;

    public IndexedIterator(@NotNull Indexed<S> items, @NotNull I iterator) {
        this.items = items;
        this.iterator = iterator;
        this.lastIndex = -1;
        this.modificationCount = items.modificationCount();
    }

    @Override
    public boolean isReversed() {
        return this.iterator.isReversed();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    @NotNull
    public R next() {
        if (this.modificationCount != this.items.modificationCount()) {
            throw new ConcurrentModificationException();
        }
        this.lastIndex = (Integer)this.iterator.next();
        return (R)this.items.get(this.lastIndex);
    }

    @Override
    public void remove() {
        if (this.lastIndex == -1) {
            throw new NoSuchElementException();
        }
        if (this.modificationCount != this.items.modificationCount()) {
            throw new ConcurrentModificationException();
        }
        this.items.removeAt(this.lastIndex);
        this.lastIndex = -1;
        this.modificationCount = this.items.modificationCount();
    }

    @Override
    public int getIndex() {
        if (this.lastIndex < 0) {
            throw new NoSuchElementException();
        }
        return this.lastIndex;
    }

    @Override
    public void forEachRemaining(@NotNull Consumer<? super R> consumer) {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

